unit Dialogs;

interface
	type
		RectPtr = ^Rect;

	procedure CenterRect (var r1: Rect; r2: Rect);

	function CenterNewDialog (dialogID: Integer; dStorage: Ptr; InFrontOf: WindowPtr): DialogPtr;

	function CenterAlert (AlertID: Integer; filterProc: ProcPtr): Integer;

	function DialogPos (id: Integer): Point;

	procedure SetVerticalCenter (flag: Boolean);
	function GetVerticalCenter: Boolean;

{High-level dialog filter utilities}
	function SFFilter (d: DialogPtr; var event: eventRecord; var item: Integer): Boolean;

{Low-level filter utilities}
	procedure DlgNullEvt (d: DialogPtr; event: EventRecord);

	procedure DlgUpdateEvt (d: DialogPtr; event: EventRecord);

	function DlgKeyDown (d: DialogPtr; var event: EventRecord; var item: Integer): Boolean;

{High-level item utilities}
	procedure SetStrItem (d: DialogPtr; i: Integer; s: Str255);
	procedure ReadStrItem (d: DialogPtr; i: Integer; var s: Str255);

	procedure ToggleItem (d: DialogPtr; i: Integer);

	procedure SetDlgCtl (d: DialogPtr; i: Integer; setting: Boolean);

	function GetDlgCtl (d: DialogPtr; i: Integer): Boolean;

	function TestDlgCtl (d: DialogPtr; i: Integer): Boolean;

	procedure DisableDlgCtl (d: DialogPtr; i: Integer);

	procedure EnableDlgCtl (d: DialogPtr; i: Integer);

	procedure XableDlgCtl (d: DialogPtr; i: Integer; flag: Boolean);

	procedure FrameDlgButton (d: DialogPtr; theItem: INTEGER);

	procedure FrameDItem (d: DialogPtr; item: Integer);

	procedure SetDCTitle (d: DialogPtr; item: Integer; title: Str255);

	procedure SimulateButton (d: DialogPtr; item: Integer);

	procedure VisDItem (d: DialogPtr; i: Integer; flag: Boolean);

	procedure SetDefaultItem (d: DialogPtr; item: Integer);
	function GetDefaultItem (d: DialogPtr): Integer;

{low-level item utilities}
	procedure SetupUserItem (d: DialogPtr; i: Integer; UserProc: ProcPtr);

	function GetIType (d: DialogPtr; item: Integer): Integer;

	function GetIRect (d: DialogPtr; item: Integer): RectPtr;
	procedure SetIRect (d: DialogPtr; item: Integer; r: Rect);

	function GetIHandle (d: DialogPtr; item: Integer): Handle;

implementation
{$IFC UNDEFINED AutoUpdate}
{$SETC AutoUpdate = TRUE}
{$ENDC}

	const
		btnControl = ctrlItem + btnCtrl;
		chkControl = ctrlItem + chkCtrl;
		radControl = ctrlItem + radCtrl;
		resControl = ctrlItem + resCtrl;

	type
		DialogItem = record
				iHandle: Handle;
				iRect: Rect;
				iType: SignedByte;
				iDataLen: SignedByte;
			end;
		PDialogItem = ^DialogItem;
		HDialogItem = ^PDialogItem;

		ItemList = record
				dlgMaxIndex: Integer;
				items: array[0..0] of DialogItem;
			end;
		PItemList = ^ItemList;
		HItemList = ^PItemList;

	function GetScreenRect: Rect;
		var
			wmgrPort: GrafPtr;
	begin
		GetWMgrPort(wmgrPort);
		GetScreenRect := wmgrPort^.portRect;
{GetScreenRect := ScreenBits.bounds;}
	end;

	function GetMBarHeight: Integer;
	inline
		$3EB8, $0BAA;

	var
		_CenterVertical: Boolean;

	procedure SetVerticalCenter;
	begin
		_CenterVertical := flag;
	end;

	function GetVerticalCenter;
	begin
		GetVerticalCenter := _CenterVertical;
	end;

	procedure CenterRect;
		var
			r1w, r1h, r2w, r2h: Integer;

	begin
		with r1 do
			r1w := (right - left) div 2;
		with r2 do
			r2w := (right - left) div 2;

		with r1 do
			r1h := (bottom - top) div 2;
		with r2 do
			r2h := (bottom - top) div 3;

		if _CenterVertical then
			begin
				with r1 do
					begin
						top := (r2h - r1h);
						if (top <= r2.top + (GetMBarHeight + 15)) then
							top := r2.top + (GetMBarHeight + 15);
					end;
			end
		else
			with r1 do
				begin
					top := r2.top + GetMBarHeight + 15;
				end;

		with r1 do
			begin
				bottom := top + (r1h * 2);
				left := r2w - r1w;
				right := left + (r1w * 2);
			end;
	end;

	function DialogPos;
		var
			dth: DialogTHndl;

	begin
		dth := DialogTHndl(GetResource('DLOG', id));
		if (dth = nil) then
			DebugStr('DLOG Resource not found.');

		CenterRect(dth^^.boundsRect, GetScreenRect);
		DialogPos := dth^^.boundsRect.topLeft;
	end;

	function CenterNewDialog;
		var
			dp: DialogPtr;
			dth: DialogTHndl;

			visible: Boolean;

	begin
		dth := DialogTHndl(GetResource('DLOG', dialogID));
		if dth = nil then
			DebugStr('DLOG resource not found.');

		CenterRect(dth^^.boundsRect, GetScreenRect);
		dp := GetNewDialog(dialogID, dStorage, InFrontOf);
{    SetupItemList(dp);}

		CenterNewDialog := dp;
		ReleaseResource(Handle(dth));
	end;

	function CenterAlert;
		var
			theAlert: AlertTHndl;

	begin
		theAlert := AlertTHndl(GetResource('ALRT', alertID));
		if theAlert = nil then
			DebugStr('ALRT resource not found.');

		CenterRect(theAlert^^.boundsRect, GetScreenRect);

		CenterAlert := Alert(alertID, filterProc);

		FreeAlert(alertID);
	end;

{$IFC AutoUpdate}
	procedure HandleActivate (event: EventRecord);
	External;

	procedure HandleUpdate (event: EventRecord);
	External;
{$ELSEC}
	procedure HandleActivate (event: EventRecord);
	begin
	end;

	procedure HandleUpdate (event: EventRecord);
	begin
	end;
{$ENDC}

	function SFFilter;
		var
			theChar: Char;

	begin
		SFFilter := false;

		case event.what of
			nullEvent: 
				DlgNullEvt(d, event);

			activateEvt: 
				if DialogPtr(event.message) <> d then
					HandleActivate(event);

			updateEvt: 
				if DialogPtr(event.message) = d then
					DlgUpdateEvt(d, event)
				else
					HandleUpdate(event);

			keyDown: 
				SFFilter := DlgKeyDown(d, event, item);

			otherwise
				;
		end;
	end;

	procedure DlgNullEvt;
		var
			savePort: GrafPtr;
			MouseLoc: Point;
			i: Integer;

			iType: Integer;
			iHdl: Handle;
			iBox: Rect;
			curs: CursHandle;

	begin
		GetPort(savePort);
		SetPort(d);
		MouseLoc := event.where;
		GlobalToLocal(MouseLoc);

		i := FindDItem(d, MouseLoc) + 1;

		if (i >= 1) then
			begin
				GetDItem(d, i, iType, iHdl, iBox);
				if (iType = editText) | (iType = editText + itemDisable) then
					begin
						curs := GetCursor(iBeamCursor);
						SetCursor(curs^^);
					end
				else
{SetCursor(arrow);}
					InitCursor;
			end
		else
{SetCursor(arrow);}
			InitCursor;

		SetPort(savePort);
	end;

	procedure DlgUpdateEvt;
		var
			savePort: GrafPtr;
			dPeek: DialogPeek;

	begin
		GetPort(savePort);
		SetPort(d);
		BeginUpdate(d);
		dPeek := DialogPeek(d);
		FrameDlgButton(d, dPeek^.aDefItem);
		DrawDialog(d);
		EndUpdate(d);
		SetPort(savePort);
	end;

	function DlgKeyDown;
		label
			100;

		const
			Enter = Chr(3);
			Return = Chr(13);
			Esc = Chr(27);
			Tab = Chr(9);

		var
			c: Char;
			i: Integer;

			cHdl: ControlHandle;

			result: Boolean;
			NoEditFields: Boolean;

		function UpperCase (ch: Char): Char;
			const
				UprDiff = Ord('a') - Ord('A');

		begin
			if (ch >= 'a') & (ch <= 'z') then
				ch := Chr(Ord(ch) - UprDiff);
			UpperCase := ch;
		end;

		function FindDlgControl (ch: Char): Integer;
			var
				i, iType: Integer;

				cHdl: ControlHandle;
				s: Str255;
				c1, c2: Char;

		begin
			FindDlgControl := 0;

			for i := 1 to HItemList(DialogPeek(d)^.Items)^^.dlgMaxIndex + 1 do
				begin
					iType := GetIType(d, i);

					if (iType in [btnControl..resControl]) then
						begin
							cHdl := ControlHandle(GetIHandle(d, i));
							GetCTitle(cHdl, s);
							c1 := s[Length(s) - 1];
							c2 := s[Length(s)];

							if (c1 = Chr($11)) & (c2 = UpperCase(ch)) & TestDlgCtl(d, i) then
								begin
									FindDlgControl := i;
									Leave;
								end;
						end;
				end;
		end;

	begin
		c := Chr(BitAnd(Event.message, charCodeMask));
		result := false;

		if BitAnd(event.modifiers, CmdKey) <> 0 then
			begin
				NoEditFields := DialogPeek(d)^.editField = -1;

				case UpperCase(c) of
					'X': 
						begin
							if NoEditFields then
								goto 100;
							DlgCut(d);
							result := True;
						end;
					'C': 
						begin
							if NoEditFields then
								goto 100;
							DlgCopy(d);
							result := True;
						end;
					'V': 
						begin
							if NoEditFields then
								goto 100;
							DlgPaste(d);
							result := True;
						end;

					otherwise
						begin
100:
							i := FindDlgControl(c);
							if i <> 0 then
								begin
									event.what := mouseDown;
									SimulateButton(d, i);
									item := i;
									result := True;
								end;
						end;
				end;
			end
		else if (BitAnd(event.Modifiers, CmdKey + OptionKey + ShiftKey) = 0) then
			begin
				case c of
					Return, Enter: 
						begin
							i := GetDefaultItem(d);
							if TestDlgCtl(d, i) then
								begin
									SimulateButton(d, i);
									item := i;
									result := true;
								end;
						end;

					Esc: 
						begin
							if (GetIType(d, 2) in [btnControl..resControl]) & TestDlgCtl(d, 2) then
								begin
									SimulateButton(d, 2);
									item := 2;
									result := true;
								end;
						end;

					otherwise
						;
				end;
			end;

		DlgKeyDown := result;
	end;

	procedure SetStrItem;
	begin
		SetIText(GetIHandle(d, i), s);
	end;

	procedure ReadStrItem;
	begin
		GetIText(GetIHandle(d, i), s);
	end;

	procedure SetDlgCtl;
	begin
		SetCtlValue(ControlHandle(GetIHandle(d, i)), Ord(setting));
	end;

	function GetDlgCtl;
	begin
		GetDlgCtl := Odd(GetCtlValue(ControlHandle(GetIHandle(d, i))));
	end;

	procedure ToggleItem;
	begin
		SetDlgCtl(d, i, not GetDlgCtl(d, i));
	end;

	procedure DisableDlgCtl;
	begin
		HiliteControl(ControlHandle(GetIHandle(d, i)), 255);
	end;

	procedure EnableDlgCtl;
	begin
		HiliteControl(ControlHandle(GetIHandle(d, i)), 0);
	end;

	function TestDlgCtl;
	begin
		TestDlgCtl := ControlHandle(GetIHandle(d, i))^^.contrlHilite <> $FF;
	end;

	procedure XAbleDlgCtl;
		var
			val: Integer;

	begin
		if flag then
			val := 0
		else
			val := 255;

		HiliteControl(ControlHandle(GetIHandle(d, i)), val);
	end;

	procedure FrameDlgButton;
		var
			itemBox: Rect;

			savePort: GrafPtr;

	begin
		if GetIType(d, theItem) = btnControl then
			begin
				GetPort(savePort);
				SetPort(d);

				itemBox := GetIRect(d, theItem)^;
				PenSize(3, 3);
				InsetRect(itemBox, -4, -4);
				FrameRoundRect(itemBox, 16, 16);
				PenSize(1, 1);

				SetPort(savePort);
			end;
	end;

	procedure FrameDItem (d: DialogPtr; item: Integer);
		var
			r: Rect;

			savePort: GrafPtr;

	begin
		GetPort(savePort);
		SetPort(d);

		r := GetIRect(d, item)^;

{with r do}
{if (bottom - top <= 1) or (right - left <= 1) then}
{PenPat(Gray);}

		FrameRect(r);

		PenNormal;

		SetPort(savePort);
	end;


	procedure SetDCTitle;
	begin
		SetCTitle(ControlHandle(GetIHandle(d, item)), title);
	end;

	procedure SimulateButton;
		var
			c: ControlHandle;

			tix: LongInt;

	begin
		c := ControlHandle(GetIHandle(d, item));
		HiliteControl(c, 1);
		Delay(10, tix);
		HiliteControl(c, 0);
	end;

	procedure SetDefaultItem;
	begin
		DialogPeek(d)^.aDefItem := item;
	end;

	function GetDefaultItem;
	begin
		GetDefaultItem := DialogPeek(d)^.aDefItem;
	end;

	procedure SetupUserItem;
		var
			iType: Integer;
			iHdl: Handle;
			iBox: Rect;

	begin
		GetDItem(d, i, iType, iHdl, iBox);
		SetDItem(d, i, iType, Handle(UserProc), iBox);
	end;

	procedure VisDItem;
	begin
		if Flag then
			ShowDItem(d, i)
		else
			HideDItem(d, i);
	end;

	var
		itemRect: Rect;

	function GetIType;
		var
			iType: Integer;
			iHdl: Handle;
			iBox: Rect;

	begin
		GetDItem(d, item, iType, iHdl, iBox);
		GetIType := iType;
	end;

	function GetIRect;
		var
			iType: Integer;
			iHdl: Handle;

	begin
		GetDItem(d, item, iType, iHdl, itemRect);
		GetIRect := @itemRect;
	end;

	procedure SetIRect;
		var
			iType: Integer;
			iHdl: Handle;
			iBox: Rect;

	begin
		GetDItem(d, item, iType, iHdl, iBox);
		SetDItem(d, item, iType, iHdl, r);
	end;

	function GetIHandle;
		var
			iType: Integer;
			iHdl: Handle;
			iBox: Rect;

	begin
		GetDItem(d, item, iType, iHdl, iBox);
		GetIHandle := iHdl;
	end;


end.